/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSAdvancedConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2919;
import net.minecraft.class_3812;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import net.minecraft.class_7059;

public class AdvancedJigsawStructure<C extends RSAdvancedConfig>
extends AbstractBaseStructure<C> {
    public AdvancedJigsawStructure(Codec<C> codec) {
        super(codec, AdvancedJigsawStructure::isAdvancedFeatureChunk, AdvancedJigsawStructure::generateAdvancedPieces);
    }

    public AdvancedJigsawStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSAdvancedConfig> boolean isAdvancedFeatureChunk(class_6834.class_6835<CC> context) {
        class_1923 chunkPos = context.comp_309();
        RSAdvancedConfig config = (RSAdvancedConfig)context.comp_310();
        if (!(context.comp_307() instanceof class_1973)) {
            for (int curChunkX = chunkPos.field_9181 - config.biomeRadius; curChunkX <= chunkPos.field_9181 + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - config.biomeRadius; curChunkZ <= chunkPos.field_9180 + config.biomeRadius; ++curChunkZ) {
                    class_2919 random = new class_2919((class_5819)new class_5820(0L));
                    random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
                    int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
                    if (context.comp_312().test(context.comp_307().method_38109(curChunkX << 2, structureStartHeight >> 2, curChunkZ << 2, context.comp_306().method_38276()))) continue;
                    return false;
                }
            }
        }
        for (class_5321<class_7059> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.comp_306().method_41053(structureSetToAvoid, context.comp_308(), chunkPos.field_9181, chunkPos.field_9180, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends RSAdvancedConfig> Optional<class_6622<CC>> generateAdvancedPieces(class_6834.class_6835<CC> context) {
        int bottomClipOff;
        int topClipOff;
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        RSAdvancedConfig config = (RSAdvancedConfig)context.comp_310();
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((class_5321)config.startPool.method_40230().get()).method_29177());
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.method_10104(class_2350.field_11036, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + config.verticalRange.get();
            bottomClipOff = structureStartHeight - config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), (class_2338)blockpos, false, false, topClipOff, bottomClipOff, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {});
    }
}

